import electric.uddi.Address;
import electric.uddi.Business;
import electric.uddi.Category;
import electric.uddi.Contact;
import electric.uddi.Description;
import electric.uddi.Email;
import electric.uddi.IUDDI;
import electric.uddi.IUDDIConstants;
import electric.uddi.Phone;
import electric.uddi.UDDIException;
import electric.uddi.client.UDDIClient;

public class BusinessEntity {

	public static void main( String[] args ) throws Exception {

		String businessEntityName = "SW-Hotels";

		String inquireURL = "";
		String publishURL = "";
		String user = "";
		String password = "";

		// Rcupration des paramtres du registre UDDI.
		if(args.length > 0) {
			inquireURL = args[0];
			publishURL = args[1];
			user = args[2];
			password = args[3];
		}

		if (inquireURL.equals("")) {
			inquireURL = "http://www.sw-registre-uddi.org:8004/glue/inquire/uddi";
		}
		if (publishURL.equals("")) {
			publishURL = "http://www.sw-registre-uddi.org:8006/glue/publish/uddi";
		}
		if (user.equals("")) {
			user = "uddi";
		}
		if (password.equals("")) {
			password = "uddi";
		}

		// Instanciation du client UDDI.
		IUDDI uddi = new UDDIClient(inquireURL, publishURL, user, password);

		// Instanciation de l'entit mtier.
		Business business = new Business(businessEntityName);

		// Instanciation d'un contact.
		Contact contact = new Contact("Jean SW-Dupont");
		contact.setUseType("PDG");
		contact.addDescription(new Description("CEO SW-Hotels", "en"));
		contact.addDescription(new Description("PDG SW-Hotels", "fr"));

		// Ajout d'une adresse mail.
		Email email = new Email("jswdupont@swvoyages.com");
		email.setUseType("not secure");
		contact.addEmail(email);

		// Ajout d'un n de tlphone.
		Phone phone = new Phone("+ 33 9 99 99 99 99");
		phone.setUseType("office number");
		contact.addPhone(phone);

		// Ajout d'une adresse.
		String[] lines = new String[]{"2345, rue des Lombards", "75001 Paris", "France"};
		Address address = new Address(lines);
		address.setUseType("sige social");
		contact.addAddress(address);

		// Affectation du contact  l'entit mtier.
		business.addContact(contact);

		// Ajout des descriptions de l'entit mtier.
		Description description = new Description("The travel at your finger tips.", "en");
		business.addDescription(description);
		description = new Description("Le voyage au bout des doigts", "fr");
		business.addDescription(description);

		// Catgorisation de l'entit mtier en "Information" (NAICS).
		// (cf. http://www.naics.com pour plus de details)
		// (cf. http://www.census.gov/epcd/naics/naicscod.txt pour la liste des codes)
		Category naics = new Category( "Information", "51" );
		naics.setTModelKey( IUDDIConstants.UDDI_NAICS_UUID );
		business.addCategory( naics );

		// Catgorisation de l'entit mtier en "Information Services and Data Processing Services" (NAICS).
		naics = new Category( "Information Services and Data Processing Services", "514" );
		naics.setTModelKey( IUDDIConstants.UDDI_NAICS_UUID );
		business.addCategory( naics );

		// Catgorisation de l'entit mtier en "Data Processing Services" (NAICS).
		naics = new Category( "Data Processing Services", "5142" );
		naics.setTModelKey( IUDDIConstants.UDDI_NAICS_UUID );
		business.addCategory( naics );

		// Publication de l'entit mtier.
		try {
			Business savedBusiness = uddi.saveBusiness(business);
			System.out.println("\nentit mtier publie\n" + savedBusiness);
		}
		catch (UDDIException e) {
			System.out.println("\nune exception " + e + " s'est produite : " + e.getDispositionReport());
		}
	}
}